<?php
/**
 * View for displaying tracking information on the order edit page
 *
 * @since 1.8.7 - Added
 * @version 1.8.7
 *
 * @package WCVendors_Pro/Admin/Views
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<table class="wp-list-table widefat fixed striped table-view-list">
	<thead>
		<th><?php esc_attr_e( 'Shop Name', 'wcvendors-pro' ); ?></th>
		<th><?php esc_attr_e( 'Shipping Provider', 'wcvendors-pro' ); ?></th>
		<th><?php esc_attr_e( 'Date Shipped', 'wcvendors-pro' ); ?></th>
		<th><?php esc_attr_e( 'Tracking Number', 'wcvendors-pro' ); ?></th>
	</thead>
	<tbody>
		<?php foreach ( $tracking_data as $tracking ) : ?>
			<tr>
				<td class="wcv-shop-url">
					<a href="<?php echo esc_html( $tracking['shop_url'] ); ?>" target="_blank">
						<?php echo esc_html( $tracking['shop_name'] ); ?>
					</a>
				</td>
				<td class="wcv-shipping-provider"><?php echo esc_html( $tracking['shipping_provider'] ); ?></td>
				<td class="wcv-date-shipped"><?php echo esc_html( $tracking['date_shipped'] ); ?></td>
				<td class="wcv-tracking-number">
					<a href="<?php echo esc_url( $tracking['tracking_url'] ); ?>" target="_blank">
						<?php echo esc_html( $tracking['tracking_number'] ); ?>
					</a>
				</td>
			</tr>
		<?php endforeach; ?>
	</tbody>
</table>
